;/*************************************************
; Program			:Test LED
; Description		:LED blink.An LED is connected to PB0.
; CPU Control		:90S8535
; File name			:LED.asm
; Assembler			:AVR Studio 4.05
;**************************************************

.include "8535def.inc"			

			.org   	$000 
    		rjmp  reset					;Reset Handle
;/************************
; Define Register
;/************************
.def		counter1  	= r16
.def		counter2	= r17
.def		counter3	= r18
.def		temp		= r19
.def		temp1		= r22
;/***********************
; Define I/O Port,Pin
;/***********************
.equ		LED		= 1
;/*******************
; Main Program
;/*******************
reset:      ldi	temp,low(RAMEND)
            out	SPL,temp          		;init Stack Pointer     
            ldi	temp,high(RAMEND)
            out	SPH,temp   

Test_LED:	ser	temp
			out	DDRB,temp
Test_L:		sbr	temp,LED
			out	PORTB,temp
			rcall	delay200ms
			cbr	temp,LED
			out	PORTB,temp
			rcall	delay200ms
			rjmp	Test_L		

;/******************
; Delay time
;/******************
delay1ms:	ldi    	counter1,8
delay1ms_1: ldi    	counter2,250
delay1ms_2: nop
			dec	counter2
            brne   	delay1ms_2
            dec counter1
            brne   	delay1ms_1
			ret          

delay200ms:	push	counter3
			ldi	counter3,200
delay200ms_1:	
			rcall	delay1ms
			dec	counter3
			brne	delay200ms_1
			pop	counter3
			ret
           	 